import os

class TransactionMixinTsv:
    def __init__(self, transaction: list):
        self.transaction = transaction
        self.fields = {
            "recordType": 0,
            "submissionId": 1,
            "submittingAgency": 2,
            "submittingSourcedb": 3,
            "submittingPublisher / name": 4,
            "submittingPublisher / nameNumber": 5,
            "submittingPublisher / role": 6,
            "submittingPublisher / email": 7,
            "workcode": 8,
            "disambiguation": 9,
            "disambiguationReason": 10,
            "disambiguateFrom": 11,
            "derivedWorkType": 12,
            "derivedFromIswcs": 13,
            "originalTitle": 14,
            "additionalIdentifiers / ISRCs": 15,
            "additionalIdentifiers / AgencyWorkCodes": 16,
            "interestedParty1 / name": 17,
            "interestedParty1 / nameNumber": 18,
            "interestedParty1 / role": 19,
        }

    def print_field_positions(self, line_num: int):
        print(f"\n📄 Line {line_num}:")
        for field, index in self.fields.items():
            if index < len(self.transaction):
                value = self.transaction[index].strip()
                print(f"  [{index}] {field}: {value if value != '' else '<EMPTY>'}")
            else:
                print(f"  [{index}] {field}: <MISSING>")


def diagnose_tsv_files():
    txt_files = [f for f in os.listdir() if f.lower().endswith('.txt')]
    if not txt_files:
        print("No TXT files found in current directory.")
        return

    for filename in txt_files:
        print(f"\n🔍 Diagnosing file: {filename}")
        with open(filename, 'r', encoding='utf-8') as file:
            for line_num, line in enumerate(file, 1):
                row = line.rstrip('\n').split('\t')
                validator = TransactionMixinTsv(row)
                validator.print_field_positions(line_num)


if __name__ == "__main__":
    diagnose_tsv_files()
